use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME             => 'Cmdline',
    AUTHOR           => 'Hans Harder <hans@atbas.org>',
    VERSION_FROM     => 'lib/Cmdline.pm',
    ABSTRACT         => 'A minimal command-line parser with short and long options in pure Perl',
    LICENSE          => 'perl_5',
    MIN_PERL_VERSION => '5.010',

    PREREQ_PM => {
        # No external dependencies — pure core Perl
    },

    META_MERGE       => {
        'meta-spec' => { version => 2 },
        resources => {
            repository => {
                type => 'git',
                url  => 'https://github.com/HansH111/Cmdline.pm.git',
                web  => 'https://github.com/HansH111/Cmdline.pm',
            },
        },
        provides => {
            'Cmdfile' => {
                file    => 'lib/Cmdfile.pm',
                version => '1.18',
            },
        },
    },

    dist  => { COMPRESS => 'gzip -9f', SUFFIX => 'gz' },
    clean => { FILES => 'Cmdline-*' },

    test => { TESTS => 't/*.t' },
);

