package Daje::Controller::Workflow;
use Mojo::Base 'Mojolicious::Controller', -signatures;
use v5.40;

# NAME
# ====
#
# Daje::Controller::Workflow - Mojolicious controller for Daje::Workflow
#
# SYNOPSIS
# ========
#
#     use Daje::Controller::Workflow;
#
# DESCRIPTION
# ===========
#
# Daje::Controller::Workflow is the controller for accessing Daje::Workflow
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#
#

use Data::Dumper;
use Mojo::JSON qw{decode_json};

sub execute($self) {

    # $self->render_later;
    $self->app->log->debug('Daje::Controller::Workflow::execute');
    my $temp = $self->req->body;
    my ($companies_pkey, $users_pkey) = $self->jwt->companies_users_pkey(
        $self->req->headers->header('X-Token-Check')
    );

    my $data->{context} = decode_json ($self->req->body);
    $data->{context}->{users_fkey} = $users_pkey;
    $data->{context}->{companies_fkey} = $companies_pkey;
    $data->{context}->{workflow}->{workflow_pkey} = 0 unless $data->{context}->{workflow}->{workflow_pkey};
    #
    # push @{$data->{actions}}, "$self->stash('wf_action')";
    # $data->{workflow}->{workflow} = $self->stash('workflow');
    # $data->{workflow}->{workflow_relation} = $self->stash('workflow_relation');
    # $data->{workflow}->{workflow_relation_key} = $self->stash('workflow_relation_key');
    # $data->{workflow}->{workflow_origin_key} = $self->stash('workflow_origin_key');
    #
    # say Dumper ($data);
    try {
        $self->workflow->workflow_pkey($data->{context}->{workflow}->{workflow_pkey});
        $self->workflow->workflow_name($data->{context}->{workflow}->{workflow});
        $self->workflow->context($data);
        $self->workflow->process($data->{context}->{workflow}->{activity});
        if($self->workflow->error->has_error() == 0) {
            $self->render(json => {'result' => 'success'});
        } else {
            $self->render(json =>
                {'result' => 'failed', data => $self->workflow->error->error()}
            );
        }
    } catch ($e) {
        $self->render(json => {'result' => 'failed', data => $e});
        $self->app->log->error('Daje::Controller::Workflow::execute ' . $e);
    };
    $self->app->log->debug('Daje::Controller::Workflow::execute ends');
}
1;
__END__





#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Controller::Workflow - Mojolicious controller for Daje::Workflow



=head1 SYNOPSIS


    use Daje::Controller::Workflow;



=head1 DESCRIPTION


Daje::Controller::Workflow is the controller for accessing Daje::Workflow



=head1 REQUIRES

L<Mojo::JSON> 

L<Data::Dumper> 

L<v5.40> 

L<Mojo::Base> 


=head1 METHODS

=head2 execute($self)

 execute($self)();


=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>




=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

