/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Image;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.Histogram;
import javax.media.jai.ROI;
import javax.media.jai.StatisticsOpImage;

final class HistogramOpImage
extends StatisticsOpImage {
    private int[] numBins;
    private double[] lowValue;
    private double[] highValue;
    private int numBands;

    private final boolean tileIntersectsROI(int n, int n2) {
        if (this.roi == null) {
            return true;
        }
        return this.roi.intersects(this.tileXToX(n), this.tileYToY(n2), this.tileWidth, this.tileHeight);
    }

    public HistogramOpImage(RenderedImage renderedImage, ROI rOI, int n, int n2, int n3, int n4, int[] nArray, double[] dArray, double[] dArray2) {
        super(renderedImage, rOI, n, n2, n3, n4);
        this.numBands = renderedImage.getSampleModel().getNumBands();
        this.numBins = new int[this.numBands];
        this.lowValue = new double[this.numBands];
        this.highValue = new double[this.numBands];
        int n5 = 0;
        while (n5 < this.numBands) {
            this.numBins[n5] = nArray.length == 1 ? nArray[0] : nArray[n5];
            this.lowValue[n5] = dArray.length == 1 ? dArray[0] : dArray[n5];
            this.highValue[n5] = dArray2.length == 1 ? dArray2[0] : dArray2[n5];
            ++n5;
        }
    }

    protected String[] getStatisticsNames() {
        String[] stringArray = new String[]{"histogram"};
        return stringArray;
    }

    protected Object createStatistics(String string) {
        if (string.equalsIgnoreCase("histogram")) {
            return new Histogram(this.numBins, this.lowValue, this.highValue);
        }
        return Image.UndefinedProperty;
    }

    protected void accumulateStatistics(String string, Raster raster, Object object) {
        Histogram histogram = (Histogram)object;
        histogram.countPixels(raster, this.roi, this.xStart, this.yStart, this.xPeriod, this.yPeriod);
    }
}

