/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.model.graph;

import at.ac.tuwien.dbai.pdfwrap.comparators.XComparator;
import at.ac.tuwien.dbai.pdfwrap.comparators.YComparator;
import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.model.graph.AdjacencyEdge;
import at.ac.tuwien.dbai.pdfwrap.utils.SegmentUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class AdjacencyGraph<T extends GenericSegment>
implements Cloneable {
    protected List<AdjacencyEdge<T>> edges = new ArrayList<AdjacencyEdge<T>>();
    protected List<T> horiz = new ArrayList<T>();
    protected List<T> vert = new ArrayList<T>();
    protected HashMap<T, List<AdjacencyEdge<T>>> edgesFrom;
    protected HashMap<T, List<AdjacencyEdge<T>>> edgesTo;

    public void addList(List<T> nodes) {
        this.horiz.addAll(nodes);
        this.vert.addAll(nodes);
    }

    public List<AdjacencyEdge<T>> getEdges() {
        return this.edges;
    }

    public void setEdges(List<AdjacencyEdge<T>> edges) {
        this.edges = edges;
    }

    public List<AdjacencyEdge<T>> horizEdges() {
        ArrayList<AdjacencyEdge<T>> retVal = new ArrayList<AdjacencyEdge<T>>();
        for (AdjacencyEdge<T> ae : this.edges) {
            if (!ae.isHorizontal()) continue;
            retVal.add(ae);
        }
        return retVal;
    }

    public List<AdjacencyEdge<T>> vertEdges() {
        ArrayList<AdjacencyEdge<T>> retVal = new ArrayList<AdjacencyEdge<T>>();
        for (AdjacencyEdge<T> ae : this.edges) {
            if (!ae.isVertical()) continue;
            retVal.add(ae);
        }
        return retVal;
    }

    public List<T> getHorizSegmentList() {
        return this.horiz;
    }

    public List<T> getVertSegmentList() {
        return this.vert;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<T> findNeighboursBelow(T thisSegment, boolean findFirst) {
        ArrayList<GenericSegment> retVal = new ArrayList<GenericSegment>();
        float threshold = 2.0f;
        int index = this.vert.indexOf(thisSegment);
        int n = index + 1;
        while (n < this.vert.size()) {
            GenericSegment o = (GenericSegment)this.vert.get(n);
            if (SegmentUtils.horizIntersect(o, thisSegment) && (SegmentUtils.horizIntersect(thisSegment, o.getXmid()) || SegmentUtils.horizIntersect(o, ((GenericSegment)thisSegment).getXmid()))) {
                if (retVal.size() > 0) {
                    if (!(o.getY1() <= ((GenericSegment)retVal.get(0)).getY1() + threshold)) return retVal;
                    retVal.add(o);
                } else {
                    retVal.add(o);
                    if (findFirst) {
                        return retVal;
                    }
                }
            }
            ++n;
        }
        return retVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<T> findNeighboursAbove(T thisSegment, boolean findFirst) {
        ArrayList<GenericSegment> retVal = new ArrayList<GenericSegment>();
        float threshold = 2.0f;
        int index = this.vert.indexOf(thisSegment);
        int n = index - 1;
        while (n >= 0) {
            GenericSegment o = (GenericSegment)this.vert.get(n);
            if (SegmentUtils.horizIntersect(o, thisSegment) && (SegmentUtils.horizIntersect(thisSegment, o.getXmid()) || SegmentUtils.horizIntersect(o, ((GenericSegment)thisSegment).getXmid()))) {
                if (retVal.size() > 0) {
                    if (!(o.getY2() >= ((GenericSegment)retVal.get(0)).getY2() - threshold)) return retVal;
                    retVal.add(o);
                } else {
                    retVal.add(o);
                    if (findFirst) {
                        return retVal;
                    }
                }
            }
            --n;
        }
        return retVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<T> findNeighboursLeft(T thisSegment, boolean findFirst) {
        ArrayList<GenericSegment> retVal = new ArrayList<GenericSegment>();
        float threshold = 1.0f;
        int index = this.horiz.indexOf(thisSegment);
        int n = index - 1;
        while (n >= 0) {
            GenericSegment o = (GenericSegment)this.horiz.get(n);
            if (SegmentUtils.vertMinIntersect(o, thisSegment, 0.4f) && !SegmentUtils.horizMinIntersect(o, thisSegment, 0.2f)) {
                if (retVal.size() > 0) {
                    if (!(o.getX2() >= ((GenericSegment)retVal.get(0)).getX2() - threshold)) return retVal;
                    retVal.add(o);
                } else {
                    retVal.add(o);
                    if (findFirst) {
                        return retVal;
                    }
                }
            }
            --n;
        }
        return retVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<T> findNeighboursRight(T thisSegment, boolean findFirst) {
        ArrayList<GenericSegment> retVal = new ArrayList<GenericSegment>();
        float threshold = 1.0f;
        int index = this.horiz.indexOf(thisSegment);
        int n = index + 1;
        while (n < this.horiz.size()) {
            GenericSegment o = (GenericSegment)this.horiz.get(n);
            if (SegmentUtils.vertMinIntersect(o, thisSegment, 0.4f) && !SegmentUtils.horizMinIntersect(o, thisSegment, 0.2f)) {
                if (retVal.size() > 0) {
                    if (!(o.getX1() <= ((GenericSegment)retVal.get(0)).getX1() + threshold)) return retVal;
                    retVal.add(o);
                } else {
                    retVal.add(o);
                    if (findFirst) {
                        return retVal;
                    }
                }
            }
            ++n;
        }
        return retVal;
    }

    private List<T> findNeighboursAbove(T thisSegment) {
        return this.findNeighboursAbove(thisSegment, false);
    }

    private List<T> findNeighboursBelow(T thisSegment) {
        return this.findNeighboursBelow(thisSegment, false);
    }

    private List<T> findNeighboursLeft(T thisSegment) {
        return this.findNeighboursLeft(thisSegment, false);
    }

    private List<T> findNeighboursRight(T thisSegment) {
        return this.findNeighboursRight(thisSegment, false);
    }

    private T findNeighbourAbove(T thisSegment) {
        List<T> l = this.findNeighboursAbove(thisSegment, true);
        if (l.size() > 0) {
            return (T)((GenericSegment)l.get(0));
        }
        return null;
    }

    private T findNeighbourBelow(T thisSegment) {
        List<T> l = this.findNeighboursBelow(thisSegment, true);
        if (l.size() > 0) {
            return (T)((GenericSegment)l.get(0));
        }
        return null;
    }

    private T findNeighbourLeft(T thisSegment) {
        List<T> l = this.findNeighboursLeft(thisSegment, true);
        if (l.size() > 0) {
            return (T)((GenericSegment)l.get(0));
        }
        return null;
    }

    private T findNeighbourRight(T thisSegment) {
        List<T> l = this.findNeighboursRight(thisSegment, true);
        if (l.size() > 0) {
            return (T)((GenericSegment)l.get(0));
        }
        return null;
    }

    public void generateEdgesSingle(T thisBlock) {
        ArrayList<T> neighboursLeft = new ArrayList<T>();
        T neighbourLeft = this.findNeighbourLeft(thisBlock);
        if (neighbourLeft != null) {
            neighboursLeft.add(neighbourLeft);
        }
        ArrayList<T> neighboursRight = new ArrayList<T>();
        T neighbourRight = this.findNeighbourRight(thisBlock);
        if (neighbourRight != null) {
            neighboursRight.add(neighbourRight);
        }
        ArrayList<T> neighboursAbove = new ArrayList<T>();
        T neighbourAbove = this.findNeighbourAbove(thisBlock);
        if (neighbourAbove != null) {
            neighboursAbove.add(neighbourAbove);
        }
        ArrayList<T> neighboursBelow = new ArrayList<T>();
        T neighbourBelow = this.findNeighbourBelow(thisBlock);
        if (neighbourBelow != null) {
            neighboursBelow.add(neighbourBelow);
        }
        for (GenericSegment theNode : neighboursLeft) {
            this.edges.add(new AdjacencyEdge<GenericSegment>((GenericSegment)thisBlock, theNode, 0));
            this.edges.add(new AdjacencyEdge<GenericSegment>(theNode, (GenericSegment)thisBlock, 1));
        }
        for (GenericSegment theNode : neighboursRight) {
            this.edges.add(new AdjacencyEdge<GenericSegment>((GenericSegment)thisBlock, theNode, 1));
            this.edges.add(new AdjacencyEdge<GenericSegment>(theNode, (GenericSegment)thisBlock, 0));
        }
        for (GenericSegment theNode : neighboursAbove) {
            this.edges.add(new AdjacencyEdge<GenericSegment>((GenericSegment)thisBlock, theNode, 2));
            this.edges.add(new AdjacencyEdge<GenericSegment>(theNode, (GenericSegment)thisBlock, 3));
        }
        for (GenericSegment theNode : neighboursBelow) {
            this.edges.add(new AdjacencyEdge<GenericSegment>((GenericSegment)thisBlock, theNode, 3));
            this.edges.add(new AdjacencyEdge<GenericSegment>(theNode, (GenericSegment)thisBlock, 2));
        }
    }

    public void generateEdgesMultiple(T thisBlock) {
        List<T> neighboursLeft = this.findNeighboursLeft(thisBlock);
        List<T> neighboursRight = this.findNeighboursRight(thisBlock);
        List<T> neighboursAbove = this.findNeighboursAbove(thisBlock);
        List<T> neighboursBelow = this.findNeighboursBelow(thisBlock);
        for (GenericSegment theNode : neighboursLeft) {
            this.edges.add(new AdjacencyEdge<GenericSegment>((GenericSegment)thisBlock, theNode, 0));
            this.edges.add(new AdjacencyEdge<GenericSegment>(theNode, (GenericSegment)thisBlock, 1));
        }
        for (GenericSegment theNode : neighboursRight) {
            this.edges.add(new AdjacencyEdge<GenericSegment>((GenericSegment)thisBlock, theNode, 1));
            this.edges.add(new AdjacencyEdge<GenericSegment>(theNode, (GenericSegment)thisBlock, 0));
        }
        for (GenericSegment theNode : neighboursAbove) {
            this.edges.add(new AdjacencyEdge<GenericSegment>((GenericSegment)thisBlock, theNode, 2));
            this.edges.add(new AdjacencyEdge<GenericSegment>(theNode, (GenericSegment)thisBlock, 3));
        }
        for (GenericSegment theNode : neighboursBelow) {
            this.edges.add(new AdjacencyEdge<GenericSegment>((GenericSegment)thisBlock, theNode, 3));
            this.edges.add(new AdjacencyEdge<GenericSegment>(theNode, (GenericSegment)thisBlock, 2));
        }
    }

    public void generateEdgesSingle() {
        this.edges.clear();
        Collections.sort(this.horiz, new XComparator());
        Collections.sort(this.vert, new YComparator());
        for (GenericSegment thisBlock : this.vert) {
            this.generateEdgesSingle(thisBlock);
        }
        this.removeDuplicateEdges();
    }

    public void generateEdgesMultiple() {
        this.edges.clear();
        Collections.sort(this.horiz, new XComparator());
        Collections.sort(this.vert, new YComparator());
        for (GenericSegment thisBlock : this.vert) {
            this.generateEdgesMultiple(thisBlock);
        }
        this.removeDuplicateEdges();
    }

    protected void removeDuplicateEdges() {
        ArrayList<AdjacencyEdge<T>> edgesToRemove = new ArrayList<AdjacencyEdge<T>>();
        for (AdjacencyEdge<T> e1 : this.edges) {
            for (AdjacencyEdge<T> e2 : this.edges) {
                if (e1.getDirection() != e2.getDirection() || e1.getNodeFrom() != e2.getNodeFrom() || e1.getNodeTo() != e2.getNodeTo() || e1 == e2 || edgesToRemove.contains(e1)) continue;
                edgesToRemove.add(e2);
            }
        }
        this.edges.removeAll(edgesToRemove);
    }

    public List<T> returnNeighboursLeft(T thisSeg) {
        ArrayList<T> retVal = new ArrayList<T>();
        for (AdjacencyEdge<T> e : this.edges) {
            if (e.getDirection() != 0 || e.getNodeFrom() != thisSeg) continue;
            retVal.add(e.getNodeTo());
        }
        return retVal;
    }

    public List<T> returnNeighboursRight(GenericSegment thisSeg) {
        ArrayList<T> retVal = new ArrayList<T>();
        for (AdjacencyEdge<T> e : this.edges) {
            if (e.getDirection() != 1 || e.getNodeFrom() != thisSeg) continue;
            retVal.add(e.getNodeTo());
        }
        return retVal;
    }

    public List<T> returnNeighboursAbove(GenericSegment thisSeg) {
        ArrayList<T> retVal = new ArrayList<T>();
        for (AdjacencyEdge<T> e : this.edges) {
            if (e.getDirection() != 2 || e.getNodeFrom() != thisSeg) continue;
            retVal.add(e.getNodeTo());
        }
        return retVal;
    }

    public List<T> returnNeighboursBelow(GenericSegment thisSeg) {
        ArrayList<T> retVal = new ArrayList<T>();
        for (AdjacencyEdge<T> e : this.edges) {
            if (e.getDirection() != 3 || e.getNodeFrom() != thisSeg) continue;
            retVal.add(e.getNodeTo());
        }
        return retVal;
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer("");
        for (GenericSegment seg : this.vert) {
            retVal.append(String.valueOf(seg.toString()) + "\n");
            List<GenericSegment> neighboursLeft = this.returnNeighboursLeft(seg);
            List<T> neighboursRight = this.returnNeighboursRight(seg);
            List<T> neighboursAbove = this.returnNeighboursAbove(seg);
            List<T> neighboursBelow = this.returnNeighboursBelow(seg);
            retVal.append("     Neighbours left: " + neighboursLeft.size() + " right: " + neighboursRight.size() + " above: " + neighboursAbove.size() + " below: " + neighboursBelow.size() + "\n");
        }
        return retVal.toString();
    }
}

