# Changelog

All notable changes to Affix.pm will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

### Changed
- **Affix is reborn!**
- Replaced backend with a custom JIT and introspection engine called [infix](https://github.com/sanko/infix.git).

## [0.11] - 2023-03-30

### Added
- Support for `WChar`.
- Rough, basic support for mangled symbols:
    - Itanium C++ ABI.
    - Rust (legacy).
- Exposed `dcNewCallVM(...)` size variable.

## [0.10] - 2023-03-11

### Added
- Support for `ArrayRef[]` with dynamic size.
- Support for empty `Struct[]`.
- Support for default values in `Struct[]`.
- Support for `WStr` (`wchar_t *`, `PWSTR`, etc.).

### Changed
- Coerced `Enum[]` types with `sv2ptr(...)`.
- Explicit `undef` values are now turned into `NULL` in `Pointer[]`, `ArrayRef[]`, etc.
- Cleaned up VM on `Affix::END()`.
- Simplified API around named subs.

### Fixed
- Ignored Perl's `PTRSIZE` to handle cases where it differs from the system's actual pointer size.

## [0.09] - 2023-01-26

### Added
- Structs may now contain a `CodeRef`.
- Bind to exported values with `pin()`.
- Exposed aggregate by value and syscall support in `Affix::Feature`.
- Delayed type resolution with `InstanceOf`.

### Fixed
- `CodeRef`, `Any`, etc. are now properly handled as aggregate members.
- Nesting `CodeRefs` used as callbacks works correctly now.
- Callbacks with unexpectedly empty return values no longer cause crashes.

## [0.08] - 2022-12-19

### Fixed
- Corrected struct alignment for perls with quadmath and/or longdouble enabled.

## [0.07] - 2022-12-17

### Changed
- Pulled upstream changes to dyncall 1.5 (unstable).

## [0.06] - 2022-12-16

### Added
- Allowed calling convention to be changed in param lists.

### Fixed
- Fix for quadmath tests.
- Fix for default struct padding when passing around by value.
- Attempted build fixes for nmake on Win32 smokers having gcc but not GNU make.

## [0.05] - 2022-12-14

### Added
- Exposed `offsetof(...)`.

### Changed
- Pulled upstream changes to dyncall 1.4 (stable).

## [0.04] - 2022-12-07

### Added
- Initial release (Affix.pm is born).

[Unreleased]: https://github.com/sanko/Affix.pm/compare/0.11...HEAD
[0.11]: https://github.com/sanko/Affix.pm/compare/0.10...0.11
[0.10]: https://github.com/sanko/Affix.pm/compare/0.09...0.10
[0.09]: https://github.com/sanko/Affix.pm/compare/0.08...0.09
[0.08]: https://github.com/sanko/Affix.pm/compare/0.07...0.08
[0.07]: https://github.com/sanko/Affix.pm/compare/0.06...0.07
[0.06]: https://github.com/sanko/Affix.pm/compare/0.05...0.06
[0.05]: https://github.com/sanko/Affix.pm/compare/0.04...0.05
[0.04]: https://github.com/sanko/Affix.pm/releases/tag/0.04
