#!/usr/bin/env perl
use strict;
use warnings;
use Test::More;
use Lugh;

# Skip if no test model is available
my $model_file = 'models/tinyllama-1.1b-chat-v1.0.Q2_K.gguf';
unless (-e $model_file) {
    plan skip_all => "No test model at $model_file - run download script";
}

plan tests => 13;

# Test Model loading
my $model = Lugh::Model->new(model => $model_file);
ok($model, 'Model created');
isa_ok($model, 'Lugh::Model');

# Basic accessors
is($model->filename, $model_file, 'filename accessor works');
is($model->architecture, 'llama', 'architecture is llama');
ok($model->n_tensors > 0, 'has tensors');
ok($model->n_kv > 0, 'has kv pairs');

# Tensor names
my @tensors = $model->tensor_names;
ok(scalar(@tensors) > 0, 'got tensor names');
ok(grep { /token_embd/ } @tensors, 'has embedding tensor');
ok(grep { /blk\.0\.attn/ } @tensors, 'has attention tensors');

# KV metadata
my @keys = $model->kv_keys;
ok(scalar(@keys) > 0, 'got kv keys');
ok(grep { /general\.architecture/ } @keys, 'has architecture key');

# Get specific values
my $ctx_len = $model->get_kv('llama.context_length');
is($ctx_len, 2048, 'context length is 2048');

my $block_count = $model->get_kv('llama.block_count');
is($block_count, 22, 'has 22 transformer blocks');

done_testing();
