package Shipment::FedEx::WSDL::TrackTypes::TrackOtherIdentifierDetail;
$Shipment::FedEx::WSDL::TrackTypes::TrackOtherIdentifierDetail::VERSION = '3.10';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://fedex.com/ws/track/v9' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %PackageIdentifier_of :ATTR(:get<PackageIdentifier>);
my %TrackingNumberUniqueIdentifier_of :ATTR(:get<TrackingNumberUniqueIdentifier>);
my %CarrierCode_of :ATTR(:get<CarrierCode>);

__PACKAGE__->_factory(
    [ qw(        PackageIdentifier
        TrackingNumberUniqueIdentifier
        CarrierCode

    ) ],
    {
        'PackageIdentifier' => \%PackageIdentifier_of,
        'TrackingNumberUniqueIdentifier' => \%TrackingNumberUniqueIdentifier_of,
        'CarrierCode' => \%CarrierCode_of,
    },
    {
        'PackageIdentifier' => 'Shipment::FedEx::WSDL::TrackTypes::TrackPackageIdentifier',
        'TrackingNumberUniqueIdentifier' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'CarrierCode' => 'Shipment::FedEx::WSDL::TrackTypes::CarrierCodeType',
    },
    {

        'PackageIdentifier' => 'PackageIdentifier',
        'TrackingNumberUniqueIdentifier' => 'TrackingNumberUniqueIdentifier',
        'CarrierCode' => 'CarrierCode',
    }
);

} # end BLOCK







1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::FedEx::WSDL::TrackTypes::TrackOtherIdentifierDetail

=head1 VERSION

version 3.10

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
TrackOtherIdentifierDetail from the namespace http://fedex.com/ws/track/v9.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * PackageIdentifier

=item * TrackingNumberUniqueIdentifier

=item * CarrierCode

=back

=head1 NAME

Shipment::FedEx::WSDL::TrackTypes::TrackOtherIdentifierDetail

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::FedEx::WSDL::TrackTypes::TrackOtherIdentifierDetail
   PackageIdentifier =>  { # Shipment::FedEx::WSDL::TrackTypes::TrackPackageIdentifier
     Type => $some_value, # TrackIdentifierType
     Value =>  $some_value, # string
   },
   TrackingNumberUniqueIdentifier =>  $some_value, # string
   CarrierCode => $some_value, # CarrierCodeType
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
