package MyInterfaces::GlobalWeather::GlobalWeatherSoap;
use strict;
use warnings;
use Class::Std::Storable;
use base qw(SOAP::WSDL::Client::Base);

# only load if it hasn't been loaded before
require MyTypemaps::GlobalWeather
	if not MyTypemaps::GlobalWeather->can('get_class');

sub START {
    $_[0]->set_proxy('http://www.webservicex.net/globalweather.asmx') if not $_[2]->{proxy};
    $_[0]->set_class_resolver('MyTypemaps::GlobalWeather')
        if not $_[2]->{class_resolver};
}

sub GetWeather {
    my ($self, $body, $header) = @_;
    return $self->SUPER::call({
    	operation => 'GetWeather',
        soap_action => 'http://www.webserviceX.NET/GetWeather',
        style => 'document',
        body => { 
            
           'use' => 'literal',
            namespace => '',
            encodingStyle => '',
            parts => [qw( MyElements::GetWeather )],
        },
        header => {
            
        },
        headerfault => {
            
        }
    }, $body, $header);
}

sub GetCitiesByCountry {
    my ($self, $body, $header) = @_;
    return $self->SUPER::call({
    	operation => 'GetCitiesByCountry',
        soap_action => 'http://www.webserviceX.NET/GetCitiesByCountry',
        style => 'document',
        body => { 
            
           'use' => 'literal',
            namespace => '',
            encodingStyle => '',
            parts => [qw( MyElements::GetCitiesByCountry )],
        },
        header => {
            
        },
        headerfault => {
            
        }
    }, $body, $header);
}



1;



__END__

=pod

=head1 NAME


MyInterfaces::GlobalWeather::GlobalWeatherSoap - SOAP Interface for the GlobalWeather Web Service

=head1 DESCRIPTION

SOAP Interface for the GlobalWeather web service 
located at http://www.webservicex.net/globalweather.asmx.

=head1 SERVICE GlobalWeather



=head2 Port GlobalWeatherSoap



=head1 METHODS

=head2 General methods

=head3 new

Constructor.

All arguments are forwarded to L<SOAP::WSDL::Client|SOAP::WSDL::Client>.

=head2 SOAP Service methods

Method synopsis is displayed with hash refs as parameters. 

The commented class names in the method's parameters denote that objects 
of the corresponding class can be passed instead of the marked hash ref.

You may pass any combination of objects, hash and list refs to these 
methods, as long as you meet the structure.



=head3 GetWeather

Get weather report for all major cities around the world.

 $interface->GetWeather(  {
    CityName =>  $some_value, # string
    CountryName =>  $some_value, # string
  },
 );
 
=head3 GetCitiesByCountry

Get all major cities by country name(full / part).

 $interface->GetCitiesByCountry(  {
    CountryName =>  $some_value, # string
  },
 );
 
	

=head1 AUTHOR

Generated by SOAP::WSDL on Tue Nov  6 21:00:30 2007

=pod