use strict;
use Test;
BEGIN { plan tests => 7 }

use Filesys::Virtual::Chroot;

my $cr;

ok(eval {
	$cr = Filesys::Virtual::Chroot->new(
		c => '/tmp',
		i => 0
	)
});

my $time = time;

ok($cr->rroot eq '/tmp');
ok($cr->vpwd eq '/');
ok(mkdir "/tmp/vchroot.$time", 0755);
ok($cr->vchdir("/vchroot.$time"));
ok($cr->rpwd eq "/tmp/vchroot.$time");
ok(rmdir "/tmp/vchroot.$time");
