#!perl
use 5.008;

use strict;
use warnings;
use utf8;

use lib qw(../lib/);

use charnames qw(:full);

binmode(STDOUT,':utf8');

my $text =<<TEXT;

1
אײַ זיק-מאיר דיק
 1 דער יורד

אַ װוּנדערלעכע געשיכטע, װאָס עס האָט געטראָפֿן מיט אײנעם
עס איז זיך פֿון דער מעשׂה 2 ר' צדוק פֿון ניקעלסבורג.
אַראָפּצונעמען אַ מוסר-השׂכּל, אַז דער מענטש זאָל ניט טאָן קײן
פֿאַלשס און אין דער גרעסטער נױט זאָל מען זיך היטן פֿון
בעטלברױט. און אױף אײביק איז יענער פֿאַרפֿלוכט, דער װאָס
האָט נאָר אײן מאָל פֿאַרזוכט. װיקוּים בנו׃ אַל תּבֿיאנו לידי מתּנת
בשׂר ודם.
 3 נעתּק ונאסף ע"י י. שפּירא.
[װאַרשע אין י. לעבענזאָהנס טיפּאָגראַפֿיע, 1855].

1. וַיְ ה ִ י און עס װאַר אין דער שטאָט ניקעלסבורג, האָט געװױנט
אַ מאָל אַ געװאַנט-קרעמער. ער האָט געהײסן ר' צדוק פּיקאַנטע.
ער איז געװען אַ גרױסער בעל-פּרנסה און ער װאַר אין דער שטאָט
גערעכנט פֿאַר אַ גרױסן קצין.
2. וַיַעַ שׂ לו שם. אױך האָט ער זיך געמאַכט אַ גרױסן נאָמען אין
דער שטאָט מיט זײַ נע נדבֿות און צדקות. עס איז אים אין דער
שול קײן מאָל אײן עליה פֿאַר אים צו טײַ ער געװען. ער איז נאָך
דערצו געװען אַ גרױסער מהדר במצװת. ער האָט אַ מאָל באַצאָלט
פֿאַר אַן אתרוג הונדערט טאָלער. פֿאַר זײַ נע קינדער האָט ער אַלע
מאָל געדונגען די בעסטע מלמדים, און האָט אױך מחזיק געװען
אױף זײַ ן טיש אָרעמע לומדים. און װי ער איז געװען, אַזױ איז
אױך געװען זײַ ן װײַ ב, זײער אַ טײַ ערעס מענטש און אַ גרױסע
אשת-חיל און דערצו אױך זײער שײן. זי איז געװען אױך פֿיל
קליגער פֿאַר אים און האָט פֿאַרשטאַנען דעם געשעפֿט פֿיל
בעסער אַלס ער.
3. אך לא לעולם חוסן. אָבער דער גליק בלײַ בט ניט אױף אײביק
איז דאָ אױך געװען מיט דעם ר' צדוק פיקאַנטע. דען אײן מאָל ַ טרײ דעם מענטשן. אין דער װעלט מוז זיך אַלץ אומדרײען. אַזױ
צום ערשטן סדר איז געװאָרן זײער אַ גרױסע שׂרפֿה. און עס
זענען פֿאַרברענט געװאָרן זײער פֿיל הײַ זער. און אױך די קראָם
מיט די סחורה פֿון דעם ר' צדוק. און אױך זײַ ן שטוב מיט גאָר די
2
װירטשאַפֿט, זילבערנע געפֿעס, און זײער פֿיל צירונג און אױך
זײער פֿיל פּאַפּירן אױף הערשאַפֿטן. זײַ ן שאָדן װאַר גרױס, גאָר
אומבאַשרײַ בלעך.
4. ויהי להם ימי החג לאבל. דער יום-טובֿ װאַר ַבײ זײ צום
טרױער און צום געװײן. ער און זײַ ן פֿרױ האָבן גאָר ניט געװוּסט
װוּהין מען זאָל זיך קערן און װענדן. גוטע פֿרײַ נד האָבן זײ אַפֿילו
אַ ביסל אונטערגעהאָלפֿן, אָבער עס איז שױן זײ ניט מעגלעך
געװען דעם געשעפֿט װידער הערצושטעלן אַזױ װי פֿריִער.
5. לא ארכו הימים. עס געװערט ניט לאַנג און זײ האָבן נעבעך
דעם פּלאַץ געמוזט פֿאַרקױפֿן אום צו מאַכן אַ קלײן קרעמל פֿון
גלאָגעװער סחורה. (ויחיו חײ צער) – און האָבן געלעבט זײער
אָרעם. די גרעסטע לײַ ט פֿון שטאָט האָבן מיט דעם ר' צדוק זײער
רחמנות געהאַט. אָבער דאָך האָבן זײ ניט געװוּסט מיט װאָס מען
זאָל אים קענען העלפֿן. זײ װאָלטן אים מאַכן פֿאַר אַ נאמן אין
דער שטאָט. אָבער דער פּרעזידענט פֿון די [דער] שטאָט האָט עס
ניט צוגעלאָזן, װײַ ל דער ר' צדוק איז געװען אַ גרױסער בעל-חובֿ,
און די געזעצע איז, אַז מען זאָל ניט אָנטרױען קהלס געלט אַזױ אַ
מענטשן, װער עס האָט שױן אַ מאָל באַנקראָטירט.
6. ויהי כּאַשר קצרה נַפֿשם בעמל האיש ההוא. און עס װאַר, אַז
די גרױסע לײַ ט פֿון שטאָט האָבן ניט געקענט מער דערטראָגן דעם
צער פֿון דיזעם געפֿאַלענעם עושר, דען װאָס אַ טאָג איז ער
געװאָרן אָרעמער און אָרעמער.
7. וַיִ וָעֲ צו יחדיו. איז ַבײ זײ געבליבן, אַז מען זאָל מאַכן אַ כּתבֿ
דער ר' צדוק און אַלע גרױסע לײַ ט און דער רבֿ זאָלן זיך אונטערחתמענען, אז
איז אַן אדם חשובֿ און א ירא־אלוהים באמת. בכן זאָל מען זען
אים אונטערצוהעלפֿן בכל עיר ועיר. דעם כּתבֿ זאָל מען געבן דעם
ר' צדוק און ער זאָל מיט אים אַרומפֿאָרן אין דער װעלט. דען זײ
האָבן קלאָר געװוּסט, אַז אַזױ אַ כּתבֿ, װאָס עס װעלן זײַ ן אױף
אים געחתמעט די גרױסע לײַ ט פֿון ניקעלסבורג און דער רבֿ, װעט
אין דער װעלט זײער װיכטיק זײַ ן און ער װעט בװדאי מאַכן אַ סך
געלט.
8. ויעשׂו כּאשר יעצו. און זײ האָבן אַזױ געטאָן װי זײ האָבן זיך
מייעץ געװען. זײ האָבן אָפּגעשריבן דעם כּתבֿ און האָבן זיך
אונטערגעשריבן. עס האָט מער ניט געפֿעלט נאָר דעם רבֿס
חתימה און װײַ טער ניט.
9. בימים ההם. אין דיזע צײַ טן איז געװען אַ רבֿ אין ניקעלסבורג
דער גרױסער ר' שמעלקע. דיזער מאַן װאַר אַ גרױסער למדן, װאָס
3
האָט ניט געהאַט זײַ ן גלײַ כן אין זײַ ן דור. און װי זײַ נע לומדות איז
געװען גרױס, אַזױ איז געװען גרױס אױך זײַ נע חסידות און זײַ ן
חכמה אין װעלטזאַכן. און זײַ ן עצה און זײַ ן װאָרט איז געװען
זײער טײַ ער און װיכטיק, אַזױ ַבײ ייִ דן און אַזױ ַבײ קריסטן. און
ער װאַר געאַכטעט אין דער װעלט װי אַ געטלעכער מאַן. צײַ ט זײַ ן
לעבן האָט ער ניט געגעבן קײן הסכּמה אױף אַ ספֿר און קײן מאָל
האָט ער ניט געגעבן אַ כּתבֿ אַ געפֿאַלענעם מענטשן, װאָס פֿאָרט
אַרום אין דער װעלט צו קלײַ בן נדבֿות, װי פֿאַר צײַ טן פֿלעגט זײַ ן
די מאָדע ַבײ אונדז ייִ דן.
10. ולכן לא אבה לחתום. און דאַהער האָט דער ר' שמעלקע ניט
געװאָלט זיך חתמענען אױך אױף דיזן כּתבֿ. חאָט עס די
שטאָטלײַ ט זײער פֿאַרדראָסן אױף אים און האָבן אים געזאָגט:
„רבי, איר קענט דיזן מענטשן ניט גלײַ כן מיט אַנדערע שלעפּערס.
איר קענט דאָך אים, אַז ער איז אַן איש-ישר וירא-אלוהיִ ם.
אוּנדזער שטאָט האָט פֿון אים זײער פֿיל מקבל טובֿה געװען. און
װײַ ל מיר װײסן װי פֿיל אײַ ער חתימה װעט אים אין דער װעלט
העלפֿן, זענט איר מחויבֿ מעבֿר צו זײַ ן אױף אײַ ער מידה און מוזט
זיך אונטערחתמענען אױף דעם כּתבֿ.”
11. ולא אבה הרבֿ. און דער רב האָט דאָך ניט געװאָלט זיך
חתמענען ביז װאַנען עס איז צו אים געקומען דער ר' צדוק אַלײן
און זײַ ן װײַ ב און האָבן פֿאַר אים ביטערלעך געװײנט, און האָבן
אים געבעטן רחמים, אַז ער זאָל זיך איבער זײ מרחם זײַ ן און אױף
זײערע קלײנע קינדער און זאָל אונטערשרײַ בן דעם כּתבֿ.
12. ויהמו מעיו עליהם. און ער האָט זיך איבער זײ דערבאַרעמט.
ער האָט ניט געקענט אױסהאַלטן, אַז דער ר' צדוק און זײַ ן
װײַ ב זאָלן פֿאַר אים שטײן און װײנען. ער האָט דעם כּתבֿ
אונטערגעשריבן און האָט זײ אױך געזאָגט: „חערט, מײַ ן טײַ ערער
ר' צדוק, איך טו אײַ ך דערמיט גאָר קײן טובֿה. עס איז אַפֿילו
אמת, אַז איר װעט מאַכן אַ פֿולע געלט. אָבער נאָך האָב איך ניט
געזען װעלכער עס האָט דעם בעטלברױט פֿאַרזוכט, אַז ער זאָל
זיך דערפֿון קענען אָפּרײַ סן. איך האָב געלעזן, אַז מען װיל מײַ ז
פֿאַרטרײַ בן פֿון אַ שטוב, זאָל מען כאַפּן עטלעכע מײַ ז און מען זאָל
[זײ] אײַ נשפּאַרן אין אַן אײַ זערנע קלעטקע, און מען זאָל זײ אַזױ
לאַנג [לאָזן] הונגערן, ביז אײנע עסט אױף די אַנדערע. און
דערנאָך, אַז מען לאָזט אַװעק די לעצטע, עסט זי קײן אַנדער זאַך,
נאָר די מײַ ז. דאָס זעלבע איז מיט דעם מענטש, װעלכער נאָר אײן
מאָל דאָס בעטלברױט פֿאַרזוכט האָט -- ער װעט שױן ניט זוכן
קײן אַנדערע פּרנסה, עס װעט אים ניט שמעקן קײן געשעפֿט אין
4
דער װעלט, נאָר בעטלען. ַמײן עצה װאָלט געװען בעסער די
שלעכטע צײַ ט איבערצוּװאַרטן. מיט דער צײַ ט ענדערט זיך אַלץ.”
אָבער װאָס העלפֿט עס? דער ר' צדוק האָט דעם כּתבֿ צוגענומען
און האָט זיך אָפּגעזעגנט מיט דעם רבֿ, און איז אין אַ פּאָר טעג
[אַרום] אַװעקגעפֿאָרן.
13. ובכל המקומות אַשר עבר. און אין אַלע ערטער װוּ ער איז
נאָר געפֿאָרן און האָט געװיזן דעם כּתבֿ פֿון ר' שמעלקען האָט ער
ֿ מאסף ממון געװען און האָט אײַ נגענומען גרױס כּבֿוד. דען די
װעלט האָט נאָך ניט זוכה געװען פֿון ר' שמעלקען אַ צורת-אות.
מען האָט דעם ר' צדוק פֿאַרגעטערט. מען האָט אים אום און אום
אײַ נגעלאַדן און מען האָט געגעבן נדבֿות צו דרײַ ציק און פֿערציק
טאָלער. עס האָט ניט געדױערט אײן יאָר און ער האָט שױן
צוזאַמענגעקליבן אַן ערך פֿון צװײ טױזנט טאָלער [און] האָט
געהאַט שױן בדעה זיך אומצוקערן אַהײם. נאָר װײַ ל ער איז געװען
פֿון ניקעלסבורג װײַ ט שױן אַן ערך פֿון הונדערט און פֿופֿציק מײַ לן,
איז ַבײ אים געבליבן, אַז ער זאָל מאַכן זײַ ן צוריקװעגס דורך
אַנדערע מקומות, כּדי ער זאָל קענען צוריקפֿאָרנדיק גאָר פֿון דאָס
ַנײ(ע) געלט מאַכן. און ער האָט טאַקע אַזױ געטאָן. ער האָט
צוריקפֿאָרנדיק געמאַכט גענױ אַזױ פֿיל געלט װי אַהערפֿאָרנדיק,
און האָט ַבײ זיך געדענקט, אַז ער װעט קומען אַהײם װעט ער
מאַכן אַ גוטן געשעפֿט און װעט אים-ירצה-השם דעם רבֿ װײַ זן, אַז
עס קען װערן אַ סוחר אױך פֿון אַ מענטש װאָס האָט שױן
געבעטלט.
14. ויהי בהיותו בדרך. און עס װאַר אַז ער איז געװעזן אין װעג
אַן ערך פֿון פֿופֿציק מײַ לן פֿון דער הײם, האָט ער זיך אָנגעטראָפֿן
אין אַ קרעטשמע מיט אַ בעל-דרשער. דיזער מאַן װאַר פֿיל קליגער
װי פֿרימער. ער האָט שױן פֿון דעם ר' צדוק און זײַ ן כּתבֿ געהערט
און האָט אים זײער מקנא געװען. נאָר יעצט, װי ער האָט זיך דאָ
מיט אים פֿונאַנדערגערעדט און דער ר' צדוק האָט אים דערצײלט,
אַז ער פֿאָרט צוריק אַהײם מיט אַ סך געלט, האָט צו אים געזאָגט
דער בעל-דרשער: „אז עס איז יאָ אַזױ, פֿאַרקױפֿט מיר דעם כּתבֿ,
איך גיב אײַ ך פֿאַר אים הונדערט דוקאַטן און פֿאָרט אײַ ך לשלום
אַהײם. װאָס אַרט אײַ ך? איך װעל מיר פֿאָרן מיט דעם כּתבֿ אין
אַנדערע לענדער און װעל עפּעס פֿאַר זיך אױך פֿאַרזאָרגן. איר
מעגט זיכער זײַ ן, אַז קײנער װעט פֿון דעם האַנדל ניט װיסן. און
פֿאַר דעם רב זאָלט איר זאָגן, אַז איר האָט דעם כּתבֿ פֿאַרלױרן,
אָדער ער איז נאָך ַבײ אײַ ך.”
5
15. ויטבֿוּ דבֿרי הדרשן. און עס זענען געפֿעלן די רײד פֿון דעם
דרשן דעם ר' צדוק און ער האָט אים פֿאַרקױפֿט דעם כּתבֿ פֿאַר
פֿיר הונדערט טאָלער, און דער בעל-דרשער האָט נאָך דערצו
געמאַכט אַ שאַרפֿע סעודה. זײ האָבן געגעסן און האָבן געטרונקען
און זענען בײדע פֿרײלעך געװעזן. און אױף מאָרגן זענען זײ זיך
פֿונאַנדערגעפֿאָרן. דער ר' צדוק איז געפֿאָרן אַהײם און דער בעל-
דרשער האָט פֿאַררײַ זט קײן אַמסטערדאַם מיט דעם כּתבֿ און האָט
דאָרטן געמאַכט גאָר די געלט. און פֿון דאָרטן איז ער אַװעק קײן
לאָנדאָן און פֿון לאָנדאָן איז ער געפֿאָרן קײן פֿראַנקרײַ ך. און װוּ
ער איז נאָר געקומען האָט ער מאסף געװען צען מאָל מער װי דער
ר' צדוק, דען ער איז געװען אַ בעטלער פֿון זײַ ן יוגנט אָן און ער
האָט פֿאַרשטאַנען דעם קונסט װי זיך ַבײ יעדערן געפֿעליק צו
מאַכן, אַ מאָל מיט חניפֿה און אַ מאָל מיט אַ יראת-שמיים-
פּענעמל. ובפֿרט אַצינד, װי ער האָט דאָ געהאַט דעם כּתבֿ פֿון דעם
רבֿ ר' שמעלקע. אויך איז ער געװען זײער אַ שײנער דרשן און אַ
גוטער מוכיח, ער האָט זיך באַרימט, אַז דער חסיד ר' שמעלקע
האָט אים געשיקט די װעלט אַ ביסל פֿרימער צו מאַכן. אום און
אום, װוּ ער איז נאָר געקומען, האָט ער זיך געלאָזט רופֿן ר' צדוק
דער מוכיִ ח פֿון ניקעלסבורג. און האָט אין אַ צײַ ט פֿון אַ יאָר צװײ
צוזאַמענגעמאַכט אַ טאָלער ֿ פֿינף טױזענט, אָבער ער האָט ניט
זוכה געװען, אַז ער זאָל פֿון זײ אַ הנאה האָבן. דען װי ער איז
געקומען אין אַ קלײן שטעטל אין פֿראַנקרײַ ך, װאָס מען רופֿט זי
נאָמור, איז ער דאָרטן פּלוצלינג זײער קראַנק געװאָרן און איז אין
דעם זעלבן טאָג געשטאָרבן אָן וידוי, דען ער האָט זיך גאָר ניט
געריכט ֿ דערױף. די ביסל ייִ דן, װאָס האָבן דאָרטן געװױנט, האָבן
זיך אַרום אים מתעסק געװען װי עס איז דער מנהג-ישׂראל. דער
רבֿ פֿון דעם שטעטל האָט אים מספּיד געװען, און נאָך דער קבֿורה
האָט דער רבֿ מיט דעם פּרעזידענט פֿון דעם מקום איבערגעזען
װאָס עס איז פֿון אים געבליבן. [װען] זײ האָבן איבערגעזען זײַ נע
כּתבֿים, האָבן זײ געפֿונען דעם כּתבֿ פֿון ניקעלסבורגער רבֿ. חאָבן
זײ פֿון אים געזען, אַז מען רופֿט אים ר' צדוק ב"ר אבֿרהם פֿון
ניקעלסבורג.
16. וימהרו ויִ כתבֿוּ. און זײ אײַ לן און שרײַ בן צו דעם ר'
שמעלקען און האָבן אים אױך אָפּגעשיקט דעם כּתבֿ. זײ האָבן
מודיִ ע געװען, אַז דער ר' צדוק איז ַבײ זײ געשטאָרבן און האָט
געלאָזן אַ קאַפּיטאַל פֿון אַ טאָלער פֿינעף טױזנט, חוץ קלײדער און
אַ גוטן זײגער. בכן, זאָלן קומען זײַ נע יורשים און זאָלן עס
אָפּנעמען.
6
17. ויהי כּבֿוא המכתבֿ אל עיר ניקעלסבורג. און עס װאַר אַלס
דער בריװ איז געקומען קײן ניקעלסבורג צו דעם רבֿ, האָט ער
געשיקט נאָך דעם ר' צדוקס װײַ ב און האָט איר אָנגעזאָגט, אַז איר
מאַן איז געשטאָרבן אין דעם שטעטל נאָמור, װאָס אין
פֿראַנקרײַ ך, און האָט איבערגעלאָזט אַ גרױסן קאַפּיטאַל. בֿכן זאָל
זי גאָר קײן שהיות מאַכן און זאָל אַהין פֿאָרן מיט איר אײנציקן
זון, אַ בחור פֿון זעכצן יאָר, אָפּצונעמען די ירושה.
18. ויתן לה מכתבֿ. אױך האָט ער איר געגעבן אַ בריװ, אױף
װעלכן עס האָבן זיך געחַ תמעט די גרױסע לײַ ט פֿון ניקעלסבורג
און ער אַלײן אױך, אַז זי איז די אַלמנה פֿון דעם ר' צדוק און דער
בחור איז דער זון, און מען זאָל זײ אָפּגעבן די ירושה. און דעם ר'
צדוקס װײַ ב איז געקומען קײן נאָמור און האָט אָפּגענומען די
ירושה אין גאַנצן און האָט זיך אומגעקערט צוריק קײן
ניקעלסבורג און האָט אָנגעהױבן צו פֿירן איר אַלטע געשעפֿט מיט
גרױס הצלחה. חאָט אָנגעטאָן קלאָג און האָט געטרױערט נאָך
אירן מאַן אַ גאַנץ יאָר, דען זי האָט אים זײער ליב געהאַט. נון
װעלן מיר לאָזן דאָ די אַלמנה ַבײ אירע געשעפֿטן און מיר װעלן
דערצײלן װאָס עס איז געװאָרן מיט דעם ר' צדוק אַלײן.
19. אוּנדזער ר' צדוק, װי ער איז אָפּגעפֿאָרן פֿון דער קרעטשמע,
װוּ ער האָט גענעכטיקט מיט דעם בעל-דרשער, װאָס ער האָט
אים פֿאַרקױפֿט דעם כּתבֿ, אַ מײַ ל צען, זענען אים איבערגעפֿאַלן
גזלנים און האָבן ַבײ אים אַװעקגענומען אַלץ װאָס ער האָט נאָר
ַבײ זיך געהאַט. ער איז פֿון זײ נמלט געװאָרן קױם אַ לעבעדיקער.
ער האָט זיך באַהאַלטן אונטער אַ שטײן אױף דעם גאָסטינעץ. בֿיז
עס זענען אָנגעפֿאָרן מענטשן, האָבן זײ אים מיטגענומען אין אַ
קלײן שטעטל. איז ער דאָרטן געזעסן עטלעכע טעג, ביז ער האָט
צוזאַמענגעבעטעלט אַ פּאָר טאָלער און האָט זיך אַװעקגעשלעפּט
װײַ טער צו פֿוס. אָבער ניט קײן ניקעלסבורג, דען ער האָט זיך
געשעמט צו קומען אַהײם אָן אַ גראָשן געלט און אָן דעם כּתבֿ.
ער האָט פֿאַרשטאַנען, אַז גאָט האָט עס אים געשטראָפֿט פֿאַר
דעם, װאָס ער האָט פֿאַרקױפֿט דעם כּתבֿ. ער האָט גענוג ֿ דערױף
חרטה געהאַט, אָבער עס איז שױן [געװען] צו שפּעט. ער האָט זיך
אַװעקגעשלעפּט קײן ליטע און פױלן און האָט זיך געװאַלגערט
איבער פֿרעמדע טישן אײניקע יאָר און האָט זיך צוגעלאָזן אַ ביסל
צום טרונק און האָט זיך גאָר אין גאַנצן פֿאַרגעסן אָן דער הײם.
ַבֿײ אים איז שױן געװען אַ קרן אַ גוטע אָנבײַ סן [און] אַ שנאַפּס.
ער פֿלעגט זיך שױן אײַ נגעפֿינען אױף חתונות און בריתן, און האָט
7
זיך אױסגעלערנט צו בעטלען גלײַ ך װי ער װאָלט אין דעם געבאָרן
געװאָרן.
20. ויהי מעיר לעיר. און ער האָט זיך געשלעפּט פֿון שטאָט צו
שטאָט, און האָט גאָר ניט געקוקט אױף קײן תּכלית. בֿיז װאַנען
ער איז געקומען קײן וילנע, די גרעסטע שטאָט פֿון ליטע, האָט ער
זיך דערקענט מיט אײנעם פֿון ניקעלסבורג, װאָס האָט דאָרטן
געװױנט שױן אַ יאָר צען. און דיזער מאַן איז געװען זײער רײַ ך און
פֿרום. ער האָט זיך זײער פֿאַרװוּנדערט איבער דיזן צדוק, דען ער
האָט אים געקאָנט אַז ער איז נאָך געװען אַן עושר און אַ מענטש
מיט אַ שײנעם כאַראַקטער און איז געװען אַן ערלעכער סוחר.
דער ר' צדוק איז אַצינד געקומען צו אים אין שטוב בעטן אַ נדבֿה,
װי דער שטײגער איז פֿון די שנאָרער. דער ניקעלסבורגער האָט
אים געגעבן אַ גילדן און האָט אים אױך געבעטן זיצן און האָט
אים געזאָגט: „מײַ ן בעסטער ייִ ד, מיר דאַכט זיך, אַז איר זענט
„אַזױ איז
ר' צדוק דער געװאַנט-קרעמער פֿון ניקעלסבורג.”
עס” – האָט אים אָפּגעענטפֿערט ר' צדוק – „איך בין אַ ֿ נשׂרף
געװאָרן, דער נױט קען דעם מענטשן צו אַלץ ברענגען.” דער
ניקעלסבורגער האָט זיך באַגאָסן מיט טרערן דאָס הערנדיק
און האָט אַזױ געזאָגט: „עס װוּנדערט מיר זײער אױף מײַ ן
געבורטסשטאָט, אַז זי זאָל פֿאַרלאָזן אַזױ אַ מענטש װי איר זענט.
גענוג מיר קרענקט עס זײער און זײער. איר זאָלט שױן פֿון מײַ ן
שטוב ניט אַרױסגײן, איך װעל אײַ ך שײן באַקלײדן און װעל אײַ ך
געבן פֿופֿציק טאָלער אױף דער הוצאה אױך אײניקע
רעקאָמענדאַציאָנען, און איר זאָלט פֿאָרן אַהײם. איר זעט דאָך
שױן, אַז מיט בעטלברױט קומט מען די װעלט ניט דורך און דאָס
איז קײן תּכלית ניט פֿאַר אײַ ך.” דער ניקעלסבורגער האָט אים ַבײ
זיך געהאַלטן אַ פּאָר װאָכן. ער האָט אים באַקלײדט און דערנאָך
האָט ער אים אָפּגעשיקט גלײַ ך קײן ניקעלסבורג מיט זײַ נעם אַ
משולח, װאָס ער פֿלעגט צושיקן אַלע יאָרן קײן לײַ פּציג.
21. ויסע ר' צדוק לבֿיתו. און דער ר' צדוק איז שױן איבער נײַ ס
געפֿאָרן אַהײם און איז געקומען בשלום אום ראש-חודש ניסן קײן
ניקעלסבורג. ער איז אָבער ניט גלײַ ך פֿאַרפֿאָרן צו זײַ ן װײַ ב. ער
האָט אַפֿילו נאָך ניט געפֿרעגט װאָס זי מאַכט, דען אין דעם
זעלביקע טאָג און אין דער זעלבן שטונדע, װאָס ער איז געקומען
אין שטאָט, האָט ער געהערט עס איז אַ ברית ַבײ אַ גרױסן נגיד,
װאָס מען האָט אים גערופֿן ר' לוי הורװיץ. האָט ער ַבײ זיך
געטראַכט, אײדער װאָס עס װעט זײַ ן -- דערװײַ ל לאָם איך האָבן אַ
גוטן אָנבײַ סן. איז ער זיך אַװעקגעגאַנגען אױף דעם ברית. עס איז
8
שױן געװען פֿאַר נאַכט און קײנער האָט אים ניט דערקענט און
[ער] האָט אַרײַ נגעזעצט צװישן אַלע פֿרעמדע אָרעמע-לײַ ט און
האָט מיטגעשפּײַ זט מיט דעם גרעסטן אַפּעטיט װי אַ בעטלער קאָן
נאָר האָבן. נון װעלן מיר דערצײלן װאָס עס איז געװאָרן מיט זײַ ן
װײַ ב און אים װעלן מיר דאָ לאָזן אױף אײן װײַ לע זיצן.
22. בימים ההם. אין דיזע צײַ טן איז געװאָרן אַן אַלמן אײנער פֿון
די ניקעלסבורגער גבֿירים. דאָס איז דער ר' לוי הורװיץ ער איז
אױך געװען אַ געװאַנט-הענדלער און האָט נאָך געהאַט לבֿד זה
זײער פֿיל געשעפֿטן. און דאַהער, אַז עס איז ַבײ אים די װײַ ב
געשטאָרבן, האָט מען אָנגעהױבן אים צו שדכנען די װײַ ב פֿון ר'
צדוק. ער האָט זיך ניט געלאָזט לאַנג רעדן, דען זי איז אים געװען
זײער געפֿעלן. זי איז געװען אַן אשת-חײל און שײן און אױך אַ
מיוחסת און איז געװען אצינד אױך גוט אין שטאַנד און האָט
געהאַלטן אין פֿירונג. קורץ אום, ער האָט איר גענומען פֿאַר אַ
װײַ ב און האָט מיט איר פֿאַרלעבט אַ יאָר זײער גליקלעך, און
אַצינד האָט זי אים געבאָרן אַ זון, אױף װעלכן ברית דער ר' צדוק
זיצט און עסט. דער עולם װאַר דאָ זײער פֿרײלעך. דען דער
הורװיץ איז געװען ביז אַהער אַ חשׂוך-בנים. מען האָט דערלאַנגט
צום טיש גענוג משקה, און דער רבֿ האָט דאָרטן געזאָגט פֿיל
תּורה און דער חזן האָט געזונגען.
23. ויהי אחר המזון. און עס װאַר נאָך דעם װי דער עולם האָט
אָפּגעגעסן און האָט אָפּגעטרונקען, איז אַרױסגעגאַנגען די
קימפּעטאָרין אַלײן מיט אַ גרױסן זאַק קלײנגעלט אום צו טײלן די
אָרעמע-לײַ ט, װאָס זענען געזעסן אין פֿאָדערשטוב. עס איז שױן
געװען רעכט נאַכט, עס האָבן געברענט זײער פֿיל ליכט. זי האָט
יעדערן געגעבן נאָך זײַ ן ערך נאָך, ביז זי איז צוגעקומען צו דעם ר'
צדוק, איר מאַן. װי ער האָט איר דערזען, האָט ער אַראָפּגערוקט
די היטל איבער דעם פּנים און האָט פֿאַרבראָכן די הענט. ער האָט
זיך געשװינד אױפֿגעכאַפּט און האָט געװאָלט אַנטלױפֿן. אָטבער
דער משרת האָט אים צוגעהאַלטן. די װײַ ב האָט געמײנט, אַז זי
האָט אים באַלײדיקט מיט אַ קלײנע נדבֿה; זי האָט אים געגעבן אַ
גרעסערע. ער אָבער רײַ סט זיך פֿאָרט, ביז דער משרת האָט אים
אַראָפּגעכאַפּט די היטל. דאָ האָט זי אים שױן דערקענט. און װײַ ל
זי האָט געמײנט, אַז ער איז געשטאָרבן, האָט זי געגלײבט אַז ער
איז געקומען פֿון יענער װעלט. זי איז געבליבן אין חלשות און עס
איז געװאָרן אַ גרױסער ליאַרעם און אַ גרױסע מישענינע. מען
האָט דעם ר' צדוק אָנגענומען, און ער האָט זיך מודה געװען, אַז
ער האָט דעם כּתבֿ פֿאַרקױפֿט. מען האָט די פֿרױ קױם
9
אָפּגעמינטערט, אָבער זי האָט ניט לאַנג געלעבט נאָך דער מעשׂה
פֿון שרעק און ביוּש. און דעם ר' צדוק האָט מען מגרש געװען פֿון
שטאָט. און דער רבֿ האָט געשטראָפֿט די נכבדים פֿאַר װאָס זײ
האָבן אים מעבֿיר געװען על דעתו און האָט געהײסן די זאַך
 פֿאַרשרײַ בן אין פּנקס פֿון ניקעלסבורג.
 Copyright © 2007 Khulyot
All Rights Reserved

דאָס קלײנע מעשׂה-ביכל (סך-הכּל 24 זײַטלעך) װערט דאָ איבערגעדרוקט געטרײַ, אָבער אין דעם 1
מאָדערנעם אױסלײג. איבעריקע װערטער װערן באַצײכנט צװישן קײַלעכדיקע קלאַמערן. הוספֿות װערן
2 געגעבן אין גראָדעקיקע קלאַמערן.
 “Nikolsburg. Bezirksstadt in Maehren, an der Bahn Lundenburg-Zellerndorf, 7173
Ew. (zahlreiche Juden); Besitzung des Grafen Mensdorf mit dem Schloss der
ausgestorbenen Familie Dietrichstein auf hohem Felsen. Weinbau. 26 Juli 1866
Praeliminarfriede zwischen Oesterreich und Preussen.” (Meyers Hand-Lexicon des
Allgemeinen Wissen. Zweite... Auflage. Leipzig: Verlag des Bibliographischen
Instituts, 1878, p. 1357). The town is not found on modern maps. It is known today by
its Czech name Mikulov. It is located south of Brno (Bruenn) and north of Vienna, just
north of the Austrian border. (Claus Buryn)
י. שפּירא איז אײנער פֿון אײַזיק-מאיר דיקס היפּש ביסל פּסעװדאָנימען. 3

TEXT

use Lingua::YI::Romanize;

my $chars;

for my $char (split('',Lingua::YI::Romanize->yivo2latn($text))) {
  $chars->{$char}++;
}

for my $char (sort keys %$chars) {
  print $char,' ',$chars->{$char},' ',sprintf("%04X",ord($char)),' ',charnames::viacode(ord($char)),"\n";
}

$chars = {};

for my $char (split('',$text)) {
  $chars->{$char}++;
}

for my $char (sort keys %$chars) {
  #print $char,' ',$chars->{$char},' ',sprintf("%04X",ord($char)),' ',charnames::viacode(ord($char)),"\n";
}

print Lingua::YI::Romanize->yivo2latn($text);
