/**
 * A JavaScript implementation of the SHA family of hashes - defined in FIPS PUB 180-4, FIPS PUB 202,
 * and SP 800-185 - as well as the corresponding HMAC implementation as defined in FIPS PUB 198-1.
 *
 * Copyright 2008-2022 Brian Turek, 1998-2009 Paul Johnston & Contributors
 * Distributed under the BSD License
 * See http://caligatio.github.com/jsSHA/ for more information
 *
 * Two ECMAScript polyfill functions carry the following license:
 *
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION ANY IMPLIED WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
 * MERCHANTABLITY OR NON-INFRINGEMENT.
 *
 * See the Apache Version 2.0 License for specific language governing permissions and limitations under the License.
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?module.exports=e():"function"==typeof define&&define.amd?define(e):(t="undefined"!=typeof globalThis?globalThis:t||self).jsSHA=e()}(this,function(){"use strict";var n=function(t,e){return(n=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(t,e){t.__proto__=e}:function(t,e){for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n])}))(t,e)};var g="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",e="ARRAYBUFFER not supported by this environment",r="UINT8ARRAY not supported by this environment";function i(t,e,n,r){for(var i,o,a=e||[0],u=(n=n||0)>>>3,s=-1===r?3:0,h=0;h<t.length;h+=1)a.length<=(i=(o=h+u)>>>2)&&a.push(0),a[i]|=t[h]<<8*(s+r*(o%4));return{value:a,binLen:8*t.length+n}}function o(t,v,y){switch(v){case"UTF8":case"UTF16BE":case"UTF16LE":break;default:throw new Error("encoding must be UTF8, UTF16BE, or UTF16LE")}switch(t){case"HEX":return function(t,e,n){var r,i,o,a=t,t=e,e=n,u=y;if(0!=a.length%2)throw new Error("String of HEX type must be in byte increments");for(var s=t||[0],h=(e=e||0)>>>3,c=-1===u?3:0,f=0;f<a.length;f+=2){if(r=parseInt(a.substr(f,2),16),isNaN(r))throw new Error("String of HEX type contains invalid characters");for(i=(o=(f>>>1)+h)>>>2;s.length<=i;)s.push(0);s[i]|=r<<8*(c+u*(o%4))}return{value:s,binLen:4*a.length+e}};case"TEXT":return function(t,e,n){var r,i,o,a,u,s,h,c,f=t,t=v,p=y,l=0,d=e||[0],w=(n=n||0)>>>3;if("UTF8"===t)for(h=-1===p?3:0,o=0;o<f.length;o+=1)for(i=[],(r=f.charCodeAt(o))<128?i.push(r):r<2048?(i.push(192|r>>>6),i.push(128|63&r)):r<55296||57344<=r?i.push(224|r>>>12,128|r>>>6&63,128|63&r):(r=65536+((1023&r)<<10|1023&f.charCodeAt(o+=1)),i.push(240|r>>>18,128|r>>>12&63,128|r>>>6&63,128|63&r)),a=0;a<i.length;a+=1){for(u=(s=l+w)>>>2;d.length<=u;)d.push(0);d[u]|=i[a]<<8*(h+p*(s%4)),l+=1}else for(h=-1===p?2:0,c="UTF16LE"===t&&1!==p||"UTF16LE"!==t&&1===p,o=0;o<f.length;o+=1){for(r=f.charCodeAt(o),!0==c&&(r=(a=255&r)<<8|r>>>8),u=(s=l+w)>>>2;d.length<=u;)d.push(0);d[u]|=r<<8*(h+p*(s%4)),l+=2}return{value:d,binLen:8*l+n}};case"B64":return function(t,e,n){var r,i,o,a,u,s,h=t,t=n,c=y,f=0,p=(n=e)||[0],l=(t=t||0)>>>3,d=-1===c?3:0,n=h.indexOf("=");if(-1===h.search(/^[a-zA-Z0-9=+/]+$/))throw new Error("Invalid character in base-64 string");if(h=h.replace(/=/g,""),-1!==n&&n<h.length)throw new Error("Invalid '=' found in base-64 string");for(r=0;r<h.length;r+=4){for(a=h.substr(r,4),i=o=0;i<a.length;i+=1)o|=g.indexOf(a.charAt(i))<<18-6*i;for(i=0;i<a.length-1;i+=1){for(u=(s=f+l)>>>2;p.length<=u;)p.push(0);p[u]|=(o>>>16-8*i&255)<<8*(d+c*(s%4)),f+=1}}return{value:p,binLen:8*f+t}};case"BYTES":return function(t,e,n){for(var r,i,o,a=t,t=n,u=y,s=e||[0],h=(t=t||0)>>>3,c=-1===u?3:0,f=0;f<a.length;f+=1)r=a.charCodeAt(f),s.length<=(i=(o=f+h)>>>2)&&s.push(0),s[i]|=r<<8*(c+u*(o%4));return{value:s,binLen:8*a.length+t}};case"ARRAYBUFFER":try{new ArrayBuffer(0)}catch(t){throw new Error(e)}return function(t,e,n){return e=e,n=n,r=y,i(new Uint8Array(t),e,n,r);var r};case"UINT8ARRAY":try{new Uint8Array(0)}catch(t){throw new Error(r)}return function(t,e,n){return i(t,e,n,y)};default:throw new Error("format must be HEX, TEXT, B64, BYTES, ARRAYBUFFER, or UINT8ARRAY")}}function a(t,l,d,w){switch(t){case"HEX":return function(t){for(var e,n=t,r=d,t=w,i="0123456789abcdef",o="",a=l/8,u=-1===r?3:0,s=0;s<a;s+=1)e=n[s>>>2]>>>8*(u+r*(s%4)),o+=i.charAt(e>>>4&15)+i.charAt(15&e);return t.outputUpper?o.toUpperCase():o};case"B64":return function(t){for(var e,n,r,i,o=t,a=l,u=d,s=w,h="",c=a/8,f=-1===u?3:0,p=0;p<c;p+=3)for(r=p+1<c?o[p+1>>>2]:0,i=p+2<c?o[p+2>>>2]:0,n=(o[p>>>2]>>>8*(f+u*(p%4))&255)<<16|(r>>>8*(f+u*((p+1)%4))&255)<<8|i>>>8*(f+u*((p+2)%4))&255,e=0;e<4;e+=1)h+=8*p+6*e<=a?g.charAt(n>>>6*(3-e)&63):s.b64Pad;return h};case"BYTES":return function(t){for(var e,n=t,r=d,i="",o=l/8,a=-1===r?3:0,u=0;u<o;u+=1)e=n[u>>>2]>>>8*(a+r*(u%4))&255,i+=String.fromCharCode(e);return i};case"ARRAYBUFFER":try{new ArrayBuffer(0)}catch(t){throw new Error(e)}return function(t){for(var e=t,n=d,r=(t=l)/8,t=new ArrayBuffer(r),i=new Uint8Array(t),o=-1===n?3:0,a=0;a<r;a+=1)i[a]=e[a>>>2]>>>8*(o+n*(a%4))&255;return t};case"UINT8ARRAY":try{new Uint8Array(0)}catch(t){throw new Error(r)}return function(t){for(var e=t,n=d,r=l/8,i=-1===n?3:0,o=new Uint8Array(r),a=0;a<r;a+=1)o[a]=e[a>>>2]>>>8*(i+n*(a%4))&255;return o};default:throw new Error("format must be HEX, B64, BYTES, ARRAYBUFFER, or UINT8ARRAY")}}var u=4294967296;function s(t){var e={outputUpper:!1,b64Pad:"=",outputLen:-1},t=t||{},n="Output length must be a multiple of 8";if(e.outputUpper=t.outputUpper||!1,t.b64Pad&&(e.b64Pad=t.b64Pad),t.outputLen){if(t.outputLen%8!=0)throw new Error(n);e.outputLen=t.outputLen}else if(t.shakeLen){if(t.shakeLen%8!=0)throw new Error(n);e.outputLen=t.shakeLen}if("boolean"!=typeof e.outputUpper)throw new Error("Invalid outputUpper formatting option");if("string"!=typeof e.b64Pad)throw new Error("Invalid b64Pad formatting option");return e}function t(t,e,n){n=n||{};if(this.inputFormat=e,this.utfType=n.encoding||"UTF8",this.numRounds=n.numRounds||1,isNaN(this.numRounds)||this.numRounds!==parseInt(this.numRounds,10)||this.numRounds<1)throw new Error("numRounds must a integer >= 1");this.shaVariant=t,this.remainder=[],this.remainderLen=0,this.updateCalled=!1,this.processedLen=0,this.macKeySet=!1,this.keyWithIPad=[],this.keyWithOPad=[]}function c(t,e){return t<<e|t>>>32-e}function f(t,e){var n=(65535&t)+(65535&e);return(65535&(t>>>16)+(e>>>16)+(n>>>16))<<16|65535&n}function p(t,e,n,r,i){var o=(65535&t)+(65535&e)+(65535&n)+(65535&r)+(65535&i);return(65535&(t>>>16)+(e>>>16)+(n>>>16)+(r>>>16)+(i>>>16)+(o>>>16))<<16|65535&o}function h(t){return[1732584193,4023233417,2562383102,271733878,3285377520]}function l(t,e){for(var n,r=[],i=e[0],o=e[1],a=e[2],u=e[3],s=e[4],h=0;h<80;h+=1)r[h]=h<16?t[h]:c(r[h-3]^r[h-8]^r[h-14]^r[h-16],1),n=h<20?p(c(i,5),o&a^~o&u,s,1518500249,r[h]):h<40?p(c(i,5),o^a^u,s,1859775393,r[h]):h<60?p(c(i,5),o&a^o&u^a&u,s,2400959708,r[h]):p(c(i,5),o^a^u,s,3395469782,r[h]),s=u,u=a,a=c(o,30),o=i,i=n;return e[0]=f(i,e[0]),e[1]=f(o,e[1]),e[2]=f(a,e[2]),e[3]=f(u,e[3]),e[4]=f(s,e[4]),e}function d(t,e,n,r){for(var i,o=15+(e+65>>>9<<4),n=e+n;t.length<=o;)t.push(0);for(t[e>>>5]|=128<<24-e%32,t[o]=4294967295&n,t[o-1]=n/u|0,i=0;i<t.length;i+=16)r=l(t.slice(i,i+16),r);return r}t.prototype.update=function(t){for(var e=0,n=this.variantBlockSize>>>5,t=this.converterFunc(t,this.remainder,this.remainderLen),r=t.binLen,i=t.value,o=r>>>5,a=0;a<o;a+=n)e+this.variantBlockSize<=r&&(this.intermediateState=this.roundFunc(i.slice(a,a+n),this.intermediateState),e+=this.variantBlockSize);return this.processedLen+=e,this.remainder=i.slice(e>>>5),this.remainderLen=r%this.variantBlockSize,this.updateCalled=!0,this},t.prototype.getHash=function(t,e){var n,r,i=this.outputBinLen,e=s(e);if(this.isVariableLen){if(-1===e.outputLen)throw new Error("Output length must be specified in options");i=e.outputLen}t=a(t,i,this.bigEndianMod,e);if(this.macKeySet&&this.getMAC)return t(this.getMAC(e));for(r=this.finalizeFunc(this.remainder.slice(),this.remainderLen,this.processedLen,this.stateCloneFunc(this.intermediateState),i),n=1;n<this.numRounds;n+=1)this.isVariableLen&&i%32!=0&&(r[r.length-1]&=16777215>>>24-i%32),r=this.finalizeFunc(r,i,0,this.newStateFunc(this.shaVariant),i);return t(r)},t.prototype.setHMACKey=function(t,e,n){if(!this.HMACSupported)throw new Error("Variant does not support HMAC");if(this.updateCalled)throw new Error("Cannot set MAC key after calling update");e=o(e,(n||{}).encoding||"UTF8",this.bigEndianMod);this._setHMACKey(e(t))},t.prototype._setHMACKey=function(t){var e,n=this.variantBlockSize>>>3,r=n/4-1;if(1!==this.numRounds)throw new Error("Cannot set numRounds with MAC");if(this.macKeySet)throw new Error("MAC key already set");for(n<t.binLen/8&&(t.value=this.finalizeFunc(t.value,t.binLen,0,this.newStateFunc(this.shaVariant),this.outputBinLen));t.value.length<=r;)t.value.push(0);for(e=0;e<=r;e+=1)this.keyWithIPad[e]=909522486^t.value[e],this.keyWithOPad[e]=1549556828^t.value[e];this.intermediateState=this.roundFunc(this.keyWithIPad,this.intermediateState),this.processedLen=this.variantBlockSize,this.macKeySet=!0},t.prototype.getHMAC=function(t,e){e=s(e);return a(t,this.outputBinLen,this.bigEndianMod,e)(this._getHMAC())},t.prototype._getHMAC=function(){var t,e;if(this.macKeySet)return t=this.finalizeFunc(this.remainder.slice(),this.remainderLen,this.processedLen,this.stateCloneFunc(this.intermediateState),this.outputBinLen),e=this.roundFunc(this.keyWithOPad,this.newStateFunc(this.shaVariant)),this.finalizeFunc(t,this.outputBinLen,this.variantBlockSize,e,this.outputBinLen);throw new Error("Cannot call getHMAC without first setting MAC key")};var w=t,v=A,y=w;if("function"!=typeof y&&null!==y)throw new TypeError("Class extends value "+String(y)+" is not a constructor or null");function m(){this.constructor=v}function A(t,e,n){var r=this;if("SHA-1"!==t)throw new Error("Chosen SHA variant is not supported");var i=n||{};return(r=w.call(this,t,e,n)||this).HMACSupported=!0,r.getMAC=r._getHMAC,r.bigEndianMod=-1,r.converterFunc=o(r.inputFormat,r.utfType,r.bigEndianMod),r.roundFunc=l,r.stateCloneFunc=function(t){return t.slice()},r.newStateFunc=h,r.finalizeFunc=d,r.intermediateState=h(),r.variantBlockSize=512,r.outputBinLen=160,r.isVariableLen=!1,i.hmacKey&&r._setHMACKey(function(t,e,n,r){if(t+=" must include a value and format",e){if(void 0!==e.value&&e.format)return o(e.format,e.encoding||"UTF8",n)(e.value)}else if(r)return r;throw new Error(t)}("hmacKey",i.hmacKey,r.bigEndianMod)),r}return n(v,y),v.prototype=null===y?Object.create(y):(m.prototype=y.prototype,new m),A});