#!/usr/bin/env perl
use strict;
use warnings;
use lib 'lib';
use lib '../XS-JIT/blib/lib';
use lib '../XS-JIT/blib/arch';

use Hypersonic;

my $server = Hypersonic->new();

# Handlers return STRINGS - they run ONCE at compile time
# The result is baked directly into native code

$server->get('/api/hello' => sub {
    '{"message":"Hello, World!"}'
});

$server->get('/health' => sub {
    'OK'
});

$server->get('/' => sub {
    '{"name":"Hypersonic","version":"0.01"}'
});

# Compile routes into JIT'd native code
print "Compiling routes...\n";
$server->compile();
print "Routes compiled!\n\n";

# Run the server
$server->run(
    port    => 8080,
    workers => 1,
);
