use strict;
use warnings;
use Test::More;

use lib 'lib';
use lib '../XS-JIT/blib/lib';
use lib '../XS-JIT/blib/arch';

use Hypersonic::Socket;

# Test platform detection
my $platform = Hypersonic::Socket::platform();
ok($platform, "Platform detected: $platform");

my $backend = Hypersonic::Socket::event_backend();
ok($backend, "Event backend: $backend");

if ($^O eq 'darwin') {
    is($backend, 'kqueue', 'macOS uses kqueue');
} elsif ($^O eq 'linux') {
    is($backend, 'epoll', 'Linux uses epoll');
}

# Test C code generation
my $code = Hypersonic::Socket::generate_ops_code();
ok(length($code) > 1000, 'Generated C code has substantial content');

# Check for key functions in generated code
like($code, qr/hypersonic_create_listen_socket/, 'Has create_listen_socket');
like($code, qr/hypersonic_create_event_loop/, 'Has create_event_loop');
like($code, qr/hypersonic_ev_poll/, 'Has ev_poll');
like($code, qr/hypersonic_http_accept/, 'Has http_accept');
like($code, qr/hypersonic_http_recv/, 'Has http_recv');
like($code, qr/hypersonic_http_send/, 'Has http_send');

# Check for platform-specific code
if ($backend eq 'epoll') {
    like($code, qr/epoll_create1/, 'Has epoll_create1');
    like($code, qr/epoll_wait/, 'Has epoll_wait');
} else {
    like($code, qr/kqueue/, 'Has kqueue');
    like($code, qr/kevent/, 'Has kevent');
}

done_testing();
